# For maps/point and click scenes.

# Define button fade animation:
transform buttonfade(speed=0.3): # Change speed's number to change the animation's fade speed.
    alpha 0.0
    on idle:
        linear speed alpha 0.0
    on selected_idle:
        linear speed alpha 1.0
    on hover:
        linear speed alpha 1.0
    on selected_hover:
        linear speed alpha 1.0

screen map_screen_1():
    #tag menu # This ensures that any other menu screen is replaced.

    ## Ensure other screens do not get input while this screen is displayed.
    #modal True
    zorder -10 # Places screen in front of the textbox, health bars, etc.
    #zorder 200 # Places screen in front of the textbox, if you'd prefer that.

    style_prefix "map"


    #Define the interactable items as imagebuttons:

    imagebutton:
        pos (700, 650)
        auto "images/disco placeholders/orb_%s.png"
        action Jump("map_1_orb_2")
        mouse "grab" # Changes cursor to a custom icon. These are defined in gui.rpy, at the bottom.

    imagebutton:
        align (0.0, 1.0)
        idle "images/disco placeholders/map_south_hover.png"
        action Jump("done_map_1") # Return back to this label in the script.
        mouse "walk" # Changes cursor to the walk icon.
        at buttonfade

# You can add more map screens to use below:

screen pnc_intro():
#tag menu # This ensures that any other menu screen is replaced.

    ## Ensure other screens do not get input while this screen is displayed.
    #modal True
    zorder -10 # Places screen in front of the textbox, health bars, etc.
    style_prefix "map"

    
    imagebutton: #desk
        pos (0.2, 0.8)
        auto "images/disco placeholders/orb_%s.png"
        action Jump ("desk_intro")
    imagebutton: #dresser
        pos (0.25, 0.2)
        auto "images/disco placeholders/orb_%s.png"
        action Jump ("dresser_intro")

    imagebutton: #door
        pos (0.01, 0.4)
        auto "images/disco placeholders/orb_%s.png"
        action Jump ("door_intro")
    imagebutton: #nightstand
        pos (0.57, 0.3)
        auto "images/disco placeholders/orb_%s.png"
        action Jump ("nightstand_intro")
    if (unlock_journal and check_dresser and door_checked and found_toys) == True:
        imagebutton: #leave
            pos (0.9, 0.9)
            idle "arrowR" 
            hover "arrowR"
            action Jump("post_pnc_1")

    else: 
        pass


screen pnc2():

    zorder -10 
    style_prefix "map"

    
    imagebutton: #desk
        pos (0.2, 0.8)
        auto "images/disco placeholders/orb_%s.png"
        action Jump ("desk_2")
    imagebutton: #dresser
        pos (0.25, 0.2)
        auto "images/disco placeholders/orb_%s.png"
        action Jump ("dresser_2")

    imagebutton: #door
        pos (0.01, 0.4)
        auto "images/disco placeholders/orb_%s.png"
        action Jump ("door_2")
    imagebutton: #nightstand
        pos (0.57, 0.3)
        auto "images/disco placeholders/orb_%s.png"
        action Jump ("nightstand_2")
    if (nightstand2c and door2c and dresser2c and desk2c) == True:
        imagebutton: #leave
            pos (0.9, 0.9)
            idle "arrowR" 
            hover "arrowR"
            action Jump("confirm_leave_2")
    else:
        pass





### LABEL JUMPS
label desk_intro:
    $ quick_menu = True

    if not unlock_journal == True:
        "The desk has a single lamp, a leather-bound book, and several pens in a metal cup. They all seem to be the standard-fancy quality you're used to."
        "The book has a sticky note on it.
        \n \"Please use at your leisure. Don't worry, no one will peek.\""
        "It appears to be a journal."
        "Curious."
        "You take the time to explore the area around the desk too, and realize there's no outlet for the lamp."
        "You inspect the lamp further, and find no cord. Instead, there's a small crystal battery."
        "A magic-powered lamp, then."
        #"(Journal is now accessible from the book icon in the bottom-left.)"
        $ unlock_journal = True
        jump pnc_1
    else: 
        "The journal is still on the desk."
        jump pnc_1

label dresser_intro:
    $ quick_menu = True
    if not check_dresser == True:
        "You open one of the drawers, but there's nothing in it."
        "There's nothing in any of the others, either."
        "It's a bit disconcerting; are you going to be stuck wearing this outfit?"
        $ check_dresser = True
        jump pnc_1
    else: 
        "There's still nothing in the dresser."
        jump pnc_1

label door_intro:
    $ quick_menu = True
    if not door_checked == True:
        "The door is solid metal, lacking a door handle. You can't tell what kind of locking mechanism it might have, electric or otherwise."
        "There's also some kind of hatch in the door. You pull it down to make a tray on your end, but when you try to stick your hand through, the other side is closed, and won't budge."
        "It reminds you of the door of a prison. Were you taken as some sort of political prisoner?"
        $ door_checked = True
        jump pnc_1
    else:
        "The door won't budge."
        jump pnc_1
label nightstand_intro:
    $ quick_menu = True
    if not found_toys == True:
        "There's nothing on top of the night stand, but when you pull open the drawer, you see an assortment of objects inside."
        "You pick one up and immediately drop it in surprise."
        "For some reason, the night stand is filled with...{w}\n 
        Sex toys? You can easily recognize dildos of varying sizes, a bottle of lube, and a fleshlight."
        "Apparently, you've been kidnapped by some kind of pervert. You scowl and slam the drawer shut. 
        If this is what your captor is leaving around, you shudder to imagine what they have planned for {i}you."
        $ found_toys = True
        jump pnc_1
    else:
        "You've seen enough."
        jump pnc_1

label desk_2:
    $ quick_menu = True
    if desk2c == False:
        "The journal sits on your desk innocently, with the pens and lamp."
        "There hasn't been much to write yet."
        "You lift the lamp, testing its weight. It might make a decent blunt weapon, if you got the chance. And the pens might be... somewhat useful, if you aim at Warden's face."
        
        $ desk2c = True
        jump pnc_2
    else:
        "You rearrange the pens."
        jump pnc_2
        
label dresser_2:
    $ quick_menu = True
    if dresser2c == False:
        "There's a single addition of another toga."
        "You wonder when Warden snuck it in."
        
        $ dresser2c = True
        jump pnc_2
    else:
        "The single toga sits in its drawer."
        jump pnc_2

label door_2:
    $ quick_menu = True
    if door2c == False:
        "The door is shut just as tightly as before. No amount of trying to force it can make it budge."
        

        $ door2c = True
        jump pnc_2
    else:
        "The door is shut just as tightly as before."
        jump pnc_2

label nightstand_2:
    $ quick_menu = True
    if nightstand2c == False:
        "With morbid curiosity, you take a peek into the nightstand again."
        "All the sex toys are still there. In fact, you feel like there's more."
        "You wonder what would happen if you shoved them through the food slot, then it's better not to touch them at all."
        

        $ nightstand2c = True
        jump pnc_2
    else:
        "Nothing worth looking at."
        jump pnc_2



label confirm_leave_2:
    $ quick_menu = True
    menu:
        "Finished?"
        "Yes.":
            jump post_pnc_2
        "No.":
            jump pnc_2

# Styles #########################

style map_image_button:
    mouse "grab" #cursor changes when hovering over buttons
